//GEMINI-pro DATASET v1.0 Category: Unit converter ; Style: peaceful
#include <stdio.h>
#include <stdlib.h>

typedef enum {
    METERS,
    KILOMETERS,
    CENTIMETERS,
    FEET,
    INCHES,
    YARDS,
    MILES,
    NAUTICAL_MILES
} Unit;

typedef struct {
    double value;
    Unit unit;
} Measurement;

Measurement convert(Measurement m, Unit to) {
    double factor;
    switch (m.unit) {
        case METERS:
            switch (to) {
                case KILOMETERS:
                    factor = 0.001;
                    break;
                case CENTIMETERS:
                    factor = 100;
                    break;
                case FEET:
                    factor = 3.28084;
                    break;
                case INCHES:
                    factor = 39.3701;
                    break;
                case YARDS:
                    factor = 1.09361;
                    break;
                case MILES:
                    factor = 0.000621371;
                    break;
                case NAUTICAL_MILES:
                    factor = 0.000539957;
                    break;
                default:
                    factor = 1;
                    break;
            }
            break;
        case KILOMETERS:
            switch (to) {
                case METERS:
                    factor = 1000;
                    break;
                case CENTIMETERS:
                    factor = 100000;
                    break;
                case FEET:
                    factor = 3280.84;
                    break;
                case INCHES:
                    factor = 39370.1;
                    break;
                case YARDS:
                    factor = 1093.61;
                    break;
                case MILES:
                    factor = 0.621371;
                    break;
                case NAUTICAL_MILES:
                    factor = 0.539957;
                    break;
                default:
                    factor = 1;
                    break;
            }
            break;
        case CENTIMETERS:
            switch (to) {
                case METERS:
                    factor = 0.01;
                    break;
                case KILOMETERS:
                    factor = 0.00001;
                    break;
                case FEET:
                    factor = 0.0328084;
                    break;
                case INCHES:
                    factor = 0.393701;
                    break;
                case YARDS:
                    factor = 0.0109361;
                    break;
                case MILES:
                    factor = 0.00000621371;
                    break;
                case NAUTICAL_MILES:
                    factor = 0.00000539957;
                    break;
                default:
                    factor = 1;
                    break;
            }
            break;
        case FEET:
            switch (to) {
                case METERS:
                    factor = 0.3048;
                    break;
                case KILOMETERS:
                    factor = 0.0003048;
                    break;
                case CENTIMETERS:
                    factor = 30.48;
                    break;
                case INCHES:
                    factor = 12;
                    break;
                case YARDS:
                    factor = 0.333333;
                    break;
                case MILES:
                    factor = 0.000189394;
                    break;
                case NAUTICAL_MILES:
                    factor = 0.000164579;
                    break;
                default:
                    factor = 1;
                    break;
            }
            break;
        case INCHES:
            switch (to) {
                case METERS:
                    factor = 0.0254;
                    break;
                case KILOMETERS:
                    factor = 0.0000254;
                    break;
                case CENTIMETERS:
                    factor = 2.54;
                    break;
                case FEET:
                    factor = 0.0833333;
                    break;
                case YARDS:
                    factor = 0.0277778;
                    break;
                case MILES:
                    factor = 0.0000157828;
                    break;
                case NAUTICAL_MILES:
                    factor = 0.0000137149;
                    break;
                default:
                    factor = 1;
                    break;
            }
            break;
        case YARDS:
            switch (to) {
                case METERS:
                    factor = 0.9144;
                    break;
                case KILOMETERS:
                    factor = 0.0009144;
                    break;
                case CENTIMETERS:
                    factor = 91.44;
                    break;
                case FEET:
                    factor = 3;
                    break;
                case INCHES:
                    factor = 36;
                    break;
                case MILES:
                    factor = 0.000568182;
                    break;
                case NAUTICAL_MILES:
                    factor = 0.000493737;
                    break;
                default:
                    factor = 1;
                    break;
            }
            break;
        case MILES:
            switch (to) {
                case METERS:
                    factor = 1609.34;
                    break;
                case KILOMETERS:
                    factor = 1.60934;
                    break;
                case CENTIMETERS:
                    factor = 160934;
                    break;
                case FEET:
                    factor = 5280;
                    break;
                case INCHES:
                    factor = 63360;
                    break;
                case YARDS:
                    factor = 1760;
                    break;
                case NAUTICAL_MILES:
                    factor = 0.868976;
                    break;
                default:
                    factor = 1;
                    break;
            }
            break;
        case NAUTICAL_MILES:
            switch (to) {
                case METERS:
                    factor = 1852;
                    break;
                case KILOMETERS:
                    factor = 1.852;
                    break;
                case CENTIMETERS:
                    factor = 185200;
                    break;
                case FEET:
                    factor = 6076.12;
                    break;
                case INCHES:
                    factor = 72913.4;
                    break;
                case YARDS:
                    factor = 2025.37;
                    break;
                case MILES:
                    factor = 1.15078;
                    break;
                default:
                    factor = 1;
                    break;
            }
            break;
        default:
            factor = 1;
            break;
    }
    Measurement result = { .value = m.value * factor, .unit = to };
    return result;
}

int main(void) {
    Measurement m = { .value = 100, .unit = METERS };
    printf("%f meters is equal to:\n", m.value);
    printf("%f kilometers\n", convert(m, KILOMETERS).value);
    printf("%f centimeters\n", convert(m, CENTIMETERS).value);
    printf("%f feet\n", convert(m, FEET).value);
    printf("%f inches\n", convert(m, INCHES).value);
    printf("%f yards\n", convert(m, YARDS).value);
    printf("%f miles\n", convert(m, MILES).value);
    printf("%f nautical miles\n", convert(m, NAUTICAL_MILES).value);
    return 0;
}