//LLAMA2-13B DATASET v1.0 Category: Ebook reader ; Style: satisfied
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>

#define MAX_BOOK_SIZE 100000
#define MAX_CHAPTERS 10
#define MAX_PAGES 50

typedef struct {
    char *title;
    char *author;
    char *chapter_list[MAX_CHAPTERS];
    int page_count;
} Book;

Book current_book;

void init_book(Book *book, char *title, char *author) {
    book->title = title;
    book->author = author;
    book->chapter_list[0] = "Chapter 1";
    book->page_count = 0;
}

void add_chapter(Book *book, char *chapter_name) {
    book->chapter_list[book->page_count] = chapter_name;
    book->page_count++;
}

void turn_page(Book *book) {
    if (book->page_count > 0) {
        book->page_count--;
    }
}

void jump_to_chapter(Book *book, int chapter_num) {
    if (chapter_num >= 0 && chapter_num < MAX_CHAPTERS) {
        book->page_count = 0;
        book->chapter_list[0] = book->chapter_list[chapter_num];
    }
}

void display_book(Book *book) {
    printf("Book: %s by %s\n", book->title, book->author);
    for (int i = 0; i < book->page_count; i++) {
        printf("Chapter %d: %s\n", i + 1, book->chapter_list[i]);
    }
}

int main() {
    Book book;
    init_book(&book, "The Great Gatsby", "F. Scott Fitzgerald");
    add_chapter(&book, "Chapter 1");
    add_chapter(&book, "Chapter 2");
    add_chapter(&book, "Chapter 3");
    display_book(&book);
    turn_page(&book);
    display_book(&book);
    jump_to_chapter(&book, 2);
    display_book(&book);
    return 0;
}