//Falcon-180B DATASET v1.0 Category: Personal Finance Planner ; Style: puzzling
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define MAX_ACCOUNTS 10
#define MAX_TRANSACTIONS 100
#define MAX_CATEGORIES 20

typedef struct {
    char name[50];
    int balance;
} account_t;

typedef struct {
    char description[100];
    int amount;
    char category[50];
} transaction_t;

typedef struct {
    char name[50];
    int count;
} category_t;

account_t accounts[MAX_ACCOUNTS];
transaction_t transactions[MAX_TRANSACTIONS];
category_t categories[MAX_CATEGORIES];

int num_accounts = 0, num_transactions = 0, num_categories = 0;

void add_account(char* name, int balance) {
    strcpy(accounts[num_accounts].name, name);
    accounts[num_accounts].balance = balance;
    num_accounts++;
}

void add_transaction(char* description, int amount, char* category) {
    strcpy(transactions[num_transactions].description, description);
    transactions[num_transactions].amount = amount;
    strcpy(transactions[num_transactions].category, category);
    num_transactions++;
}

void add_category(char* name) {
    strcpy(categories[num_categories].name, name);
    num_categories++;
}

void print_accounts() {
    printf("Accounts:\n");
    for (int i = 0; i < num_accounts; i++) {
        printf("%s: $%d\n", accounts[i].name, accounts[i].balance);
    }
}

void print_transactions() {
    printf("Transactions:\n");
    for (int i = 0; i < num_transactions; i++) {
        printf("%s: $%d (%s)\n", transactions[i].description, transactions[i].amount, transactions[i].category);
    }
}

void print_categories() {
    printf("Categories:\n");
    for (int i = 0; i < num_categories; i++) {
        printf("%s: %d transactions\n", categories[i].name, categories[i].count);
    }
}

int main() {
    add_account("Checking", 1000);
    add_account("Savings", 5000);
    add_category("Groceries");
    add_category("Entertainment");

    add_transaction("Paycheck", 2000, "Checking");
    add_transaction("Rent", -1000, "Checking");
    add_transaction("Movie tickets", -50, "Entertainment");
    add_transaction("Grocery shopping", -200, "Groceries");

    print_accounts();
    print_transactions();
    print_categories();

    return 0;
}