//GPT-4o-mini DATASET v1.0 Category: Performance-Critical Component ; Style: Romeo and Juliet
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>

// Structure to represent the two star-crossed lovers
typedef struct {
    char name[50];
    int passion;
    int patience;
    int destiny;
} LoveBird;

// Function Prototype Declarations
int calculateCompatibility(LoveBird a, LoveBird b);
void declareLove(LoveBird a, LoveBird b, int compatibility);

int main() {
    LoveBird romeo, juliet;

    // Initialization of Romeo
    strcpy(romeo.name, "Romeo");
    romeo.passion = 95;   // Passionate heart
    romeo.patience = 85;  // Steadfast in love
    romeo.destiny = 73;   // Fate's interference

    // Initialization of Juliet
    strcpy(juliet.name, "Juliet");
    juliet.passion = 90;  // Fiery spirit
    juliet.patience = 88; // Endurance in trials
    juliet.destiny = 80;  // Star-crossed fate

    // Calculate Compatibility
    int compatibility = calculateCompatibility(romeo, juliet);

    // Declare their love based on compatibility
    declareLove(romeo, juliet, compatibility);

    return 0;
}

// Function to calculate compatibility using a unique romantic formula
int calculateCompatibility(LoveBird a, LoveBird b) {
    return ((a.passion * b.passion) + (a.patience * b.patience) + (a.destiny * b.destiny)) / 3;
}

// Function to declare love based on compatibility results
void declareLove(LoveBird a, LoveBird b, int compatibility) {
    if (compatibility > 85) {
        printf("%s: Oh, sweet Juliet, my heart beats only for thee!\n", a.name);
        printf("%s: And mine for thee, dear Romeo! What say you to our love?\n", b.name);
        printf("%s & %s: Our love is a fusion of passion, patience, and destiny, totaling a compatibility of %d!\n",
               a.name, b.name, compatibility);
    } else if (compatibility > 65) {
        printf("%s: Juliet, our fates entwine, yet the stars are misaligned, compatibility is %d...\n", a.name, compatibility);
        printf("%s: Indeed, Romeo, let us strive through the trials of fate.\n", b.name);
    } else {
        printf("%s: Oh Juliet, our love is as fleeting as the summer’s day, compatibility rests at %d.\n", a.name, compatibility);
        printf("%s: Let us not mourn, sweet Romeo. Let time tell our tale...\n", b.name);
    }
}

// Function to print the details of a LoveBird
void printLoveBirdDetails(LoveBird lover) {
    printf("Name: %s\n", lover.name);
    printf("Passion Level: %d\n", lover.passion);
    printf("Patience Level: %d\n", lover.patience);
    printf("Destiny Index: %d\n", lover.destiny);
}