//Falcon-180B DATASET v1.0 Category: Stock market tracker ; Style: active
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define MAX_STOCKS 100
#define MAX_NAME_LENGTH 50

typedef struct {
    char name[MAX_NAME_LENGTH];
    float price;
    int quantity;
} stock;

void add_stock(stock* stocks, int num_stocks, char* name, float price, int quantity) {
    int i;
    for (i = 0; i < num_stocks; i++) {
        if (strcmp(stocks[i].name, name) == 0) {
            stocks[i].price = price;
            stocks[i].quantity += quantity;
            return;
        }
    }
    if (num_stocks >= MAX_STOCKS) {
        printf("Error: maximum number of stocks reached.\n");
        return;
    }
    strcpy(stocks[num_stocks].name, name);
    stocks[num_stocks].price = price;
    stocks[num_stocks].quantity = quantity;
    num_stocks++;
}

void remove_stock(stock* stocks, int num_stocks, char* name) {
    int i;
    for (i = 0; i < num_stocks; i++) {
        if (strcmp(stocks[i].name, name) == 0) {
            stocks[i].price = 0;
            stocks[i].quantity = 0;
            return;
        }
    }
    printf("Error: stock not found.\n");
}

void update_stock_price(stock* stocks, int num_stocks, char* name, float price) {
    int i;
    for (i = 0; i < num_stocks; i++) {
        if (strcmp(stocks[i].name, name) == 0) {
            stocks[i].price = price;
            return;
        }
    }
    printf("Error: stock not found.\n");
}

void update_stock_quantity(stock* stocks, int num_stocks, char* name, int quantity) {
    int i;
    for (i = 0; i < num_stocks; i++) {
        if (strcmp(stocks[i].name, name) == 0) {
            stocks[i].quantity += quantity;
            return;
        }
    }
    printf("Error: stock not found.\n");
}

void print_stocks(stock* stocks, int num_stocks) {
    int i;
    for (i = 0; i < num_stocks; i++) {
        if (stocks[i].price > 0) {
            printf("%s - %.2f (%d)\n", stocks[i].name, stocks[i].price, stocks[i].quantity);
        }
    }
}

int main() {
    stock stocks[MAX_STOCKS];
    int num_stocks = 0;

    add_stock(stocks, num_stocks, "AAPL", 150.00, 100);
    add_stock(stocks, num_stocks, "MSFT", 200.00, 50);

    print_stocks(stocks, num_stocks);

    update_stock_price(stocks, num_stocks, "AAPL", 160.00);
    update_stock_quantity(stocks, num_stocks, "MSFT", 75);

    print_stocks(stocks, num_stocks);

    remove_stock(stocks, num_stocks, "AAPL");

    print_stocks(stocks, num_stocks);

    return 0;
}