//MISTRAL-7B DATASET v1.0 Category: Interprocess communication ; Style: synchronous
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <fcntl.h>
#include <string.h>
#include <errno.h>

#define PIPE_NAME "/tmp/mypipe"
#define BUFFER_SIZE 100

void die(const char *msg) {
    perror(msg);
    exit(EXIT_FAILURE);
}

int main(int argc, char *argv[]) {
    int fd_pipe[2], fd_producer, fd_consumer;
    char buffer[BUFFER_SIZE];
    pid_t pid;

    if (pipe(fd_pipe) < 0)
        die("pipe");

    fd_producer = fork();
    if (fd_producer < 0)
        die("fork: producer");

    if (fd_producer == 0) { // Producer process
        close(fd_pipe[0]); // Close read end of pipe

        for (int i = 0; i < 5; i++) {
            if (write(fd_pipe[1], "Hello World!", strlen("Hello World!")) <= 0)
                die("write: producer");
            printf("Produced: %s\n", "Hello World!");
        }

        close(fd_pipe[1]); // Close write end of pipe
        exit(EXIT_SUCCESS);
    }

    fd_consumer = fork();
    if (fd_consumer < 0)
        die("fork: consumer");

    if (fd_consumer == 0) { // Consumer process
        close(fd_pipe[1]); // Close write end of pipe

        for (int i = 0; i < 5; i++) {
            memset(buffer, 0, BUFFER_SIZE);
            if (read(fd_pipe[0], buffer, BUFFER_SIZE) <= 0)
                die("read: consumer");
            printf("Consumed: %s\n", buffer);
        }

        close(fd_pipe[0]); // Close read end of pipe
        exit(EXIT_SUCCESS);
    }

    close(fd_pipe[0]); // Close read end of pipe (parent process)
    close(fd_pipe[1]); // Close write end of pipe (parent process)

    waitpid(fd_producer, NULL, 0);
    waitpid(fd_consumer, NULL, 0);

    return EXIT_SUCCESS;
}