//LLAMA2-13B DATASET v1.0 Category: Sorting ; Style: detailed
#include <stdio.h>
#include <stdlib.h>
#include <time.h>

#define ARRAY_SIZE 10

// Structure to represent a person
typedef struct {
    char name[20];
    int age;
} person_t;

// Function to swap two elements in an array
void swap(person_t arr[], int i, int j) {
    person_t temp = arr[i];
    arr[i] = arr[j];
    arr[j] = temp;
}

// Function to sort the array using selection sort
void sort(person_t arr[], int n) {
    int i, j, min_idx;
    for (i = 0; i < n - 1; i++) {
        // Find the smallest element in the unsorted portion of the array
        min_idx = i;
        for (j = i + 1; j < n; j++) {
            if (arr[j].age < arr[min_idx].age) {
                min_idx = j;
            }
        }
        // Swap the smallest element with the first element of the unsorted portion
        swap(arr, min_idx, i);
    }
}

// Function to print the sorted array
void print_array(person_t arr[], int n) {
    int i;
    for (i = 0; i < n; i++) {
        printf("%s %d\n", arr[i].name, arr[i].age);
    }
}

int main() {
    // Define the array of persons
    person_t arr[ARRAY_SIZE] = {
        {"Alice", 25},
        {"Bob", 30},
        {"Charlie", 35},
        {"David", 20},
        {"Eve", 28},
        {"Frank", 40},
        {"Grace", 22},
        {"Helen", 32},
        {"Ivy", 24},
        {"Jessica", 27}
    };

    // Sort the array using selection sort
    sort(arr, ARRAY_SIZE);

    // Print the sorted array
    print_array(arr, ARRAY_SIZE);

    return 0;
}