//GEMINI-pro DATASET v1.0 Category: Building a IMAP Client ; Style: detailed
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>

int main() {
  int sockfd, portno;
  struct sockaddr_in serv_addr;
  char buffer[1024];

  /* Create a socket */
  sockfd = socket(AF_INET, SOCK_STREAM, 0);
  if (sockfd < 0) {
    perror("ERROR opening socket");
    exit(1);
  }

  /* Set up the server address */
  portno = 143;
  memset(&serv_addr, 0, sizeof(serv_addr));
  serv_addr.sin_family = AF_INET;
  serv_addr.sin_addr.s_addr = inet_addr("127.0.0.1");
  serv_addr.sin_port = htons(portno);

  /* Connect to the server */
  if (connect(sockfd, (struct sockaddr *) &serv_addr, sizeof(serv_addr)) < 0) {
    perror("ERROR connecting");
    exit(1);
  }

  /* Send a LOGIN command */
  strcpy(buffer, "LOGIN username password");
  if (send(sockfd, buffer, strlen(buffer), 0) < 0) {
    perror("ERROR sending LOGIN command");
    exit(1);
  }

  /* Receive the server's response */
  memset(buffer, 0, sizeof(buffer));
  if (recv(sockfd, buffer, sizeof(buffer), 0) < 0) {
    perror("ERROR receiving server's response");
    exit(1);
  }

  /* Print the server's response */
  printf("%s\n", buffer);

  /* Send a LIST command */
  strcpy(buffer, "LIST \"\" *");
  if (send(sockfd, buffer, strlen(buffer), 0) < 0) {
    perror("ERROR sending LIST command");
    exit(1);
  }

  /* Receive the server's response */
  memset(buffer, 0, sizeof(buffer));
  if (recv(sockfd, buffer, sizeof(buffer), 0) < 0) {
    perror("ERROR receiving server's response");
    exit(1);
  }

  /* Print the server's response */
  printf("%s\n", buffer);

  /* Send a QUIT command */
  strcpy(buffer, "QUIT");
  if (send(sockfd, buffer, strlen(buffer), 0) < 0) {
    perror("ERROR sending QUIT command");
    exit(1);
  }

  /* Close the socket */
  close(sockfd);

  return 0;
}