//Falcon-180B DATASET v1.0 Category: Task Scheduler ; Style: surrealist
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <sys/wait.h>

#define MAX_PROCESSES 10
#define MAX_COMMAND_LENGTH 1024

typedef struct {
    char command[MAX_COMMAND_LENGTH];
    int priority;
} process;

int num_processes = 0;
process processes[MAX_PROCESSES];

void add_process(char* command, int priority) {
    if (num_processes >= MAX_PROCESSES) {
        printf("Error: Too many processes.\n");
        exit(1);
    }

    strcpy(processes[num_processes].command, command);
    processes[num_processes].priority = priority;
    num_processes++;
}

int compare_processes(const void* a, const void* b) {
    process* p1 = (process*)a;
    process* p2 = (process*)b;

    if (p1->priority > p2->priority)
        return -1;
    else if (p1->priority < p2->priority)
        return 1;
    else
        return 0;
}

void schedule() {
    printf("Scheduling...\n");

    qsort(processes, num_processes, sizeof(process), compare_processes);

    for (int i = 0; i < num_processes; i++) {
        printf("Executing process %s with priority %d\n", processes[i].command, processes[i].priority);
        system(processes[i].command);
    }
}

int main() {
    add_process("ls", 1);
    add_process("echo Hello, world!", 2);
    add_process("sleep 5", 3);

    schedule();

    return 0;
}