//Gemma-7B DATASET v1.0 Category: Intrusion detection system ; Style: thoughtful
#include <stdio.h>
#include <string.h>
#include <unistd.h>

#define MAX_LOG_SIZE 1024

typedef struct IntrusionDetectionLog {
    char timestamp[26];
    char source_ip[16];
    char source_port;
    char target_ip[16];
    char target_port;
    char attack_type;
    char impact;
} IntrusionDetectionLog;

IntrusionDetectionLog logs[MAX_LOG_SIZE];
int log_size = 0;

void log_intrusion(char *source_ip, int source_port, char *target_ip, int target_port, char attack_type, char impact) {
    if (log_size >= MAX_LOG_SIZE) {
        return;
    }

    logs[log_size].timestamp[0] = '\0';
    logs[log_size].source_ip[0] = '\0';
    logs[log_size].source_port = 0;
    logs[log_size].target_ip[0] = '\0';
    logs[log_size].target_port = 0;
    logs[log_size].attack_type = '\0';
    logs[log_size].impact = '\0';

    strcpy(logs[log_size].source_ip, source_ip);
    logs[log_size].source_port = source_port;
    strcpy(logs[log_size].target_ip, target_ip);
    logs[log_size].target_port = target_port;
    logs[log_size].attack_type = attack_type;
    logs[log_size].impact = impact;

    log_size++;
}

int main() {
    log_intrusion("192.168.1.1", 80, "192.168.1.2", 22, "Denial of Service", "High");

    log_intrusion("192.168.1.3", 443, "192.168.1.4", 80, "Unauthorized Access", "Medium");

    for (int i = 0; i < log_size; i++) {
        printf("Timestamp: %s\n", logs[i].timestamp);
        printf("Source IP: %s\n", logs[i].source_ip);
        printf("Source Port: %d\n", logs[i].source_port);
        printf("Target IP: %s\n", logs[i].target_ip);
        printf("Target Port: %d\n", logs[i].target_port);
        printf("Attack Type: %s\n", logs[i].attack_type);
        printf("Impact: %s\n", logs[i].impact);
        printf("\n");
    }

    return 0;
}