//GEMINI-pro DATASET v1.0 Category: URL Sanitizer ; Style: real-life
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <curl/curl.h>

// Custom callback function to sanitize URLs
size_t sanitize_url(char *buffer, size_t size, size_t nitems, void *userdata) {
    // Get the original URL
    char *original_url = (char *)userdata;

    // Allocate memory for the sanitized URL
    char *sanitized_url = malloc(size * nitems + 1);
    if (sanitized_url == NULL) {
        return 0;
    }

    // Copy the original URL into the sanitized URL
    strcpy(sanitized_url, original_url);

    // Replace any unsafe characters with their HTML-encoded equivalents
    for (char *p = sanitized_url; *p != '\0'; p++) {
        switch (*p) {
            case '<':
                *p = '&';
                p++;
                *p = 'l';
                p++;
                *p = 't';
                break;
            case '>':
                *p = '&';
                p++;
                *p = 'g';
                p++;
                *p = 't';
                break;
            case '&':
                *p = '&';
                p++;
                *p = 'a';
                p++;
                *p = 'm';
                p++;
                *p = 'p';
                break;
            case '"':
                *p = '&';
                p++;
                *p = 'q';
                p++;
                *p = 'u';
                p++;
                *p = 'o';
                p++;
                *p = 't';
                break;
            case '\'':
                *p = '&';
                p++;
                *p = 'a';
                p++;
                *p = 'p';
                p++;
                *p = 'o';
                p++;
                *p = 's';
                break;
        }
    }

    // Write the sanitized URL to the buffer
    strncpy(buffer, sanitized_url, size * nitems);
    free(sanitized_url);

    // Return the number of bytes written
    return size * nitems;
}

int main(int argc, char *argv[]) {
    // Initialize the CURL library
    curl_global_init(CURL_GLOBAL_DEFAULT);

    // Create a new CURL handle
    CURL *curl = curl_easy_init();
    if (curl == NULL) {
        fprintf(stderr, "Error: Failed to create CURL handle.\n");
        return EXIT_FAILURE;
    }

    // Set the URL to fetch
    char *url = "https://example.com/index.html";

    // Set the callback function to sanitize the URL
    curl_easy_setopt(curl, CURLOPT_URL, url);
    curl_easy_setopt(curl, CURLOPT_WRITEFUNCTION, sanitize_url);
    curl_easy_setopt(curl, CURLOPT_WRITEDATA, url);

    // Perform the request
    CURLcode res = curl_easy_perform(curl);
    if (res != CURLE_OK) {
        fprintf(stderr, "Error: Failed to perform CURL request.\n");
        return EXIT_FAILURE;
    }

    // Get the sanitized URL
    char sanitized_url[1024];
    curl_easy_getinfo(curl, CURLINFO_EFFECTIVE_URL, sanitized_url);

    // Print the sanitized URL
    printf("Sanitized URL: %s\n", sanitized_url);

    // Cleanup the CURL handle
    curl_easy_cleanup(curl);

    // Cleanup the CURL library
    curl_global_cleanup();

    return EXIT_SUCCESS;
}