//GPT-4o-mini DATASET v1.0 Category: Pixel Art Generator ; Style: interoperable
#include <stdio.h>
#include <stdlib.h>

#define WIDTH 10
#define HEIGHT 10

void initializeCanvas(char canvas[HEIGHT][WIDTH]) {
    for (int i = 0; i < HEIGHT; i++) {
        for (int j = 0; j < WIDTH; j++) {
            canvas[i][j] = ' ';
        }
    }
}

void drawPixel(char canvas[HEIGHT][WIDTH], int x, int y, char color) {
    if (x >= 0 && x < WIDTH && y >= 0 && y < HEIGHT) {
        canvas[y][x] = color;
    }
}

void drawSmileyFace(char canvas[HEIGHT][WIDTH]) {
    // Draw head
    for (int i = 3; i < 7; i++) {
        for (int j = 1; j < 9; j++) {
            if ((i == 3 && j != 1 && j != 8) || (i == 6 && j != 1 && j != 8)) {
                drawPixel(canvas, j, i, '#');
            }
            if (i > 3 && i < 6) {
                drawPixel(canvas, j, i, '#');
            }
        }
    }
    
    // Draw eyes
    drawPixel(canvas, 3, 4, 'O');
    drawPixel(canvas, 3, 5, 'O');
    
    // Draw mouth
    drawPixel(canvas, 5, 6, '_');
    drawPixel(canvas, 4, 6, '/');
    drawPixel(canvas, 3, 6, '\\');
}

void printCanvas(char canvas[HEIGHT][WIDTH]) {
    for (int i = 0; i < HEIGHT; i++) {
        for (int j = 0; j < WIDTH; j++) {
            putchar(canvas[i][j]);
        }
        putchar('\n');
    }
}

int main() {
    char canvas[HEIGHT][WIDTH];

    // Step 1: Initialize the canvas
    initializeCanvas(canvas);

    // Step 2: Draw a smiley face
    drawSmileyFace(canvas);

    // Step 3: Print the canvas
    printCanvas(canvas);

    return 0;
}