//Falcon2-11B DATASET v1.0 Category: Socket programming ; Style: expert-level
#include <stdio.h>
#include <stdlib.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <string.h>
#include <unistd.h>

int main() {
    int server_fd, new_socket, port;
    struct sockaddr_in server_addr, client_addr;
    int opt;

    // Create a socket for the server
    if ((server_fd = socket(AF_INET, SOCK_STREAM, 0)) == -1) {
        perror("socket failed");
        exit(EXIT_FAILURE);
    }

    // Set up the server address
    server_addr.sin_family = AF_INET;
    server_addr.sin_addr.s_addr = INADDR_ANY;
    server_addr.sin_port = htons(80);

    // Bind the socket to the address
    if (bind(server_fd, (struct sockaddr *)&server_addr, sizeof(server_addr)) == -1) {
        perror("bind failed");
        exit(EXIT_FAILURE);
    }

    // Listen for incoming connections
    if (listen(server_fd, 5) == -1) {
        perror("listen failed");
        exit(EXIT_FAILURE);
    }

    // Accept a new connection
    if ((new_socket = accept(server_fd, (struct sockaddr *)&client_addr, (socklen_t*)&port)) == -1) {
        perror("accept failed");
        exit(EXIT_FAILURE);
    }

    // Send a message to the client
    if (send(new_socket, "Welcome to my website!", strlen("Welcome to my website!"), 0) == -1) {
        perror("send failed");
        exit(EXIT_FAILURE);
    }

    // Close the socket
    close(new_socket);

    return 0;
}