//GEMINI-pro DATASET v1.0 Category: Bitwise operations ; Style: real-life
#include <stdio.h>
#include <stdlib.h>

// Define the bits for each color channel
#define RED_BIT 0x01
#define GREEN_BIT 0x02
#define BLUE_BIT 0x04

// Define a struct to represent a color
typedef struct {
    unsigned char red: 1;
    unsigned char green: 1;
    unsigned char blue: 1;
} Color;

// Create a function to set the color of a pixel
void set_pixel_color(unsigned char *pixel, Color color) {
    // Clear the existing color bits
    *pixel &= ~(RED_BIT | GREEN_BIT | BLUE_BIT);

    // Set the new color bits
    *pixel |= (color.red << 0) | (color.green << 1) | (color.blue << 2);
}

// Create a function to get the color of a pixel
Color get_pixel_color(unsigned char pixel) {
    Color color;

    // Extract the color bits
    color.red = (pixel & RED_BIT) >> 0;
    color.green = (pixel & GREEN_BIT) >> 1;
    color.blue = (pixel & BLUE_BIT) >> 2;

    return color;
}

// Create a function to invert the colors of a pixel
void invert_pixel_colors(unsigned char *pixel) {
    // Invert the color bits
    *pixel ^= (RED_BIT | GREEN_BIT | BLUE_BIT);
}

// Create a function to rotate the colors of a pixel
void rotate_pixel_colors(unsigned char *pixel) {
    // Rotate the color bits
    *pixel = (*pixel << 1) | (*pixel >> 2);
}

// Create a function to print the color of a pixel
void print_pixel_color(Color color) {
    printf("Red: %d, Green: %d, Blue: %d\n", color.red, color.green, color.blue);
}

int main() {
    // Create a pixel and set its color to red
    unsigned char pixel = 0;
    Color color = {1, 0, 0};
    set_pixel_color(&pixel, color);

    // Print the color of the pixel
    printf("Pixel color: ");
    print_pixel_color(get_pixel_color(pixel));

    // Invert the colors of the pixel
    invert_pixel_colors(&pixel);

    // Print the color of the pixel
    printf("Inverted pixel color: ");
    print_pixel_color(get_pixel_color(pixel));

    // Rotate the colors of the pixel
    rotate_pixel_colors(&pixel);

    // Print the color of the pixel
    printf("Rotated pixel color: ");
    print_pixel_color(get_pixel_color(pixel));

    return 0;
}