//GPT-4o-mini DATASET v1.0 Category: Database querying ; Style: peaceful
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sqlite3.h>

// A serene structure to hold book records
typedef struct {
    int id;
    char title[100];
    char author[100];
    int year;
} Book;

// Function to open a connection to the SQLite database
int open_db(sqlite3 **db, const char *filename) {
    int exit_code = sqlite3_open(filename, db);
    if (exit_code != SQLITE_OK) {
        fprintf(stderr, "Can't open database: %s\n", sqlite3_errmsg(*db));
        return exit_code;
    }
    return SQLITE_OK;
}

// Function to create a table for books if it does not exist
void create_table(sqlite3 *db) {
    char *err_msg = 0;
    const char *sql = "CREATE TABLE IF NOT EXISTS Books("
                      "ID INTEGER PRIMARY KEY AUTOINCREMENT,"
                      "Title TEXT NOT NULL,"
                      "Author TEXT NOT NULL,"
                      "Year INTEGER NOT NULL);";
    
    int exit_code = sqlite3_exec(db, sql, 0, 0, &err_msg);
    if (exit_code != SQLITE_OK) {
        fprintf(stderr, "SQL error: %s\n", err_msg);
        sqlite3_free(err_msg);
    } else {
        printf("Table created successfully.\n");
    }
}

// Function to add a new book to the database
void add_book(sqlite3 *db, Book book) {
    char *err_msg = 0;
    char sql[256];

    snprintf(sql, sizeof(sql), "INSERT INTO Books (Title, Author, Year) VALUES ('%s', '%s', %d);",
             book.title, book.author, book.year);

    int exit_code = sqlite3_exec(db, sql, 0, 0, &err_msg);
    if (exit_code != SQLITE_OK) {
        fprintf(stderr, "SQL error: %s\n", err_msg);
        sqlite3_free(err_msg);
    } else {
        printf("Book added: %s by %s (%d)\n", book.title, book.author, book.year);
    }
}

// Callback function to display books in a harmonious manner
int display_books(void *NotUsed, int argc, char **argv, char **azColName) {
    (void)NotUsed; // to avoid unused parameter warning
    printf("\nBook Details:\n");
    for (int i = 0; i < argc; i++) {
        printf("%s = %s\n", azColName[i], argv[i] ? argv[i] : "NULL");
    }
    printf("\n");
    return 0;
}

// Function to query and display all books
void query_books(sqlite3 *db) {
    char *err_msg = 0;
    const char *sql = "SELECT * FROM Books;";

    int exit_code = sqlite3_exec(db, sql, display_books, 0, &err_msg);
    if (exit_code != SQLITE_OK) {
        fprintf(stderr, "SQL error: %s\n", err_msg);
        sqlite3_free(err_msg);
    }
}

// Clean up and close the database connection
void close_db(sqlite3 *db) {
    sqlite3_close(db);
    printf("Database connection closed peacefully.\n");
}

int main() {
    sqlite3 *db;
    const char *db_filename = "books.db";

    if (open_db(&db, db_filename) != SQLITE_OK) {
        return EXIT_FAILURE;
    }

    create_table(db);

    // Peaceful addition of books to the collection
    Book book1 = {0, "The Tao of Programming", "Charles Piazza", 1987};
    Book book2 = {0, "Zen and the Art of Motorcycle Maintenance", "Robert M. Pirsig", 1974};

    add_book(db, book1);
    add_book(db, book2);

    // Querying and displaying books
    printf("Here is your collection of books:\n");
    query_books(db);

    close_db(db);
    return EXIT_SUCCESS;
}