//MISTRAL-7B DATASET v1.0 Category: Weather simulation ; Style: ephemeral
#include <stdio.h>
#include <stdlib.h>
#include <time.h>

#define WEATHER_TYPES 5
#define CITY_COUNT 3
#define WEATHER_DATA_SIZE 20

typedef struct Weather {
    int id;
    char name[20];
    float temperature;
    float humidity;
    char weather[10];
} Weather;

Weather cityWeathers[CITY_COUNT];

void generateRandomWeather(Weather *weather) {
    int weatherType = rand() % WEATHER_TYPES;

    switch (weatherType) {
        case 0:
            strcpy(weather->weather, "Sunny");
            weather->temperature = rand() % 30 + 20;
            weather->humidity = rand() % 51 + 40;
            break;
        case 1:
            strcpy(weather->weather, "Rainy");
            weather->temperature = rand() % 20 + 10;
            weather->humidity = rand() % 91 + 60;
            break;
        case 2:
            strcpy(weather->weather, "Cloudy");
            weather->temperature = rand() % 25 + 15;
            weather->humidity = rand() % 71 + 50;
            break;
        case 3:
            strcpy(weather->weather, "Snowy");
            weather->temperature = rand() % 15 + 5;
            weather->humidity = rand() % 81 + 70;
            break;
        case 4:
            strcpy(weather->weather, "Windy");
            weather->temperature = rand() % 25 + 10;
            weather->humidity = rand() % 61 + 50;
            break;
    }
}

int main() {
    srand(time(NULL));

    for (int i = 0; i < CITY_COUNT; i++) {
        cityWeathers[i].id = i + 1;
        strcpy(cityWeathers[i].name, "City");
        cityWeathers[i].temperature = 0;
        cityWeathers[i].humidity = 0;

        generateRandomWeather(&cityWeathers[i]);
    }

    printf("City Weather Report\n");

    for (int i = 0; i < CITY_COUNT; i++) {
        printf("\nCity %d, %s: ", cityWeathers[i].id, cityWeathers[i].name);
        printf("Temperature: %.2f, Humidity: %.2f, Weather: %s\n", cityWeathers[i].temperature, cityWeathers[i].humidity, cityWeathers[i].weather);
    }

    return 0;
}