//GEMINI-pro DATASET v1.0 Category: System administration ; Style: grateful
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>

int main() {
    // Open a file and write some data to it
    int fd = open("test.txt", O_WRONLY | O_CREAT | O_TRUNC, 0644);
    if (fd == -1) {
        perror("open");
        exit(1);
    }

    const char *data = "Hello, world!\n";
    if (write(fd, data, strlen(data)) == -1) {
        perror("write");
        exit(1);
    }

    // Close the file
    if (close(fd) == -1) {
        perror("close");
        exit(1);
    }

    // Fork a child process
    pid_t child_pid = fork();
    if (child_pid == -1) {
        perror("fork");
        exit(1);
    }

    // In the child process, execute a new program
    if (child_pid == 0) {
        execlp("cat", "cat", "test.txt", NULL);
        perror("execlp");
        exit(1);
    }

    // In the parent process, wait for the child process to finish
    int status;
    if (waitpid(child_pid, &status, 0) == -1) {
        perror("waitpid");
        exit(1);
    }

    // Check the child process's exit status
    if (WIFEXITED(status)) {
        printf("Child process exited with status %d\n", WEXITSTATUS(status));
    } else {
        printf("Child process terminated abnormally\n");
    }

    return 0;
}