//GEMINI-pro DATASET v1.0 Category: Electronic Voting System ; Style: protected
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define MAX_CANDIDATES 10
#define MAX_VOTERS 100

typedef struct {
    char name[50];
    int votes;
} candidate_t;

typedef struct {
    char name[50];
    int voted;
} voter_t;

// Function to initialize the election
void init_election(candidate_t candidates[], int num_candidates, voter_t voters[], int num_voters) {
    // Initialize candidates
    for (int i = 0; i < num_candidates; i++) {
        strcpy(candidates[i].name, "");
        candidates[i].votes = 0;
    }

    // Initialize voters
    for (int i = 0; i < num_voters; i++) {
        strcpy(voters[i].name, "");
        voters[i].voted = 0;
    }
}

// Function to add a candidate to the election
void add_candidate(candidate_t candidates[], int *num_candidates, char name[]) {
    if (*num_candidates < MAX_CANDIDATES) {
        strcpy(candidates[*num_candidates].name, name);
        (*num_candidates)++;
    } else {
        printf("Error: Maximum number of candidates reached.\n");
    }
}

// Function to add a voter to the election
void add_voter(voter_t voters[], int *num_voters, char name[]) {
    if (*num_voters < MAX_VOTERS) {
        strcpy(voters[*num_voters].name, name);
        (*num_voters)++;
    } else {
        printf("Error: Maximum number of voters reached.\n");
    }
}

// Function to cast a vote for a candidate
void cast_vote(candidate_t candidates[], int num_candidates, voter_t voters[], int num_voters, char name[]) {
    // Find the candidate with the given name
    int candidate_index = -1;
    for (int i = 0; i < num_candidates; i++) {
        if (strcmp(candidates[i].name, name) == 0) {
            candidate_index = i;
            break;
        }
    }

    // Check if the candidate was found
    if (candidate_index == -1) {
        printf("Error: Candidate not found.\n");
    } else {
        // Find the voter with the given name
        int voter_index = -1;
        for (int i = 0; i < num_voters; i++) {
            if (strcmp(voters[i].name, name) == 0) {
                voter_index = i;
                break;
            }
        }

        // Check if the voter was found
        if (voter_index == -1) {
            printf("Error: Voter not found.\n");
        } else {
            // Check if the voter has already voted
            if (voters[voter_index].voted) {
                printf("Error: Voter has already voted.\n");
            } else {
                // Cast the vote
                candidates[candidate_index].votes++;
                voters[voter_index].voted = 1;
            }
        }
    }
}

// Function to print the election results
void print_results(candidate_t candidates[], int num_candidates) {
    printf("Election results:\n");
    for (int i = 0; i < num_candidates; i++) {
        printf("%s: %d votes\n", candidates[i].name, candidates[i].votes);
    }
}

// Main function
int main() {
    // Initialize the election
    candidate_t candidates[MAX_CANDIDATES];
    int num_candidates = 0;
    voter_t voters[MAX_VOTERS];
    int num_voters = 0;
    init_election(candidates, num_candidates, voters, num_voters);

    // Add candidates to the election
    add_candidate(candidates, &num_candidates, "John Doe");
    add_candidate(candidates, &num_candidates, "Jane Doe");
    add_candidate(candidates, &num_candidates, "Bob Smith");

    // Add voters to the election
    add_voter(voters, &num_voters, "Alice");
    add_voter(voters, &num_voters, "Bob");
    add_voter(voters, &num_voters, "Carol");

    // Cast votes
    cast_vote(candidates, num_candidates, voters, num_voters, "John Doe");
    cast_vote(candidates, num_candidates, voters, num_voters, "Jane Doe");
    cast_vote(candidates, num_candidates, voters, num_voters, "Bob Smith");

    // Print the election results
    print_results(candidates, num_candidates);

    return 0;
}