//GEMINI-pro DATASET v1.0 Category: Queue Implementation ; Style: high level of detail
#include <stdio.h>
#include <stdlib.h>

#define QUEUE_SIZE 10

typedef struct Queue {
    int data[QUEUE_SIZE];
    int front;
    int rear;
} Queue;

void enqueue(Queue *queue, int data) {
    if ((queue->rear + 1) % QUEUE_SIZE == queue->front) {
        printf("Queue is full\n");
    } else {
        queue->rear = (queue->rear + 1) % QUEUE_SIZE;
        queue->data[queue->rear] = data;
    }
}

int dequeue(Queue *queue) {
    if (queue->front == queue->rear) {
        printf("Queue is empty\n");
        return -1;
    } else {
        queue->front = (queue->front + 1) % QUEUE_SIZE;
        return queue->data[queue->front];
    }
}

int peek(Queue *queue) {
    if (queue->front == queue->rear) {
        printf("Queue is empty\n");
        return -1;
    } else {
        return queue->data[(queue->front + 1) % QUEUE_SIZE];
    }
}

int isEmpty(Queue *queue) {
    return queue->front == queue->rear;
}

int isFull(Queue *queue) {
    return (queue->rear + 1) % QUEUE_SIZE == queue->front;
}

void printQueue(Queue *queue) {
    if (isEmpty(queue)) {
        printf("Queue is empty\n");
    } else {
        int i = queue->front + 1;
        while (i != (queue->rear + 1) % QUEUE_SIZE) {
            printf("%d ", queue->data[i]);
            i = (i + 1) % QUEUE_SIZE;
        }
        printf("\n");
    }
}

int main() {
    Queue queue;
    queue.front = queue.rear = -1;

    enqueue(&queue, 1);
    enqueue(&queue, 2);
    enqueue(&queue, 3);
    enqueue(&queue, 4);
    enqueue(&queue, 5);

    printQueue(&queue);

    printf("Dequeued element: %d\n", dequeue(&queue));
    printf("Dequeued element: %d\n", dequeue(&queue));

    enqueue(&queue, 6);
    enqueue(&queue, 7);

    printQueue(&queue);

    printf("Dequeued element: %d\n", dequeue(&queue));
    printf("Dequeued element: %d\n", dequeue(&queue));
    printf("Dequeued element: %d\n", dequeue(&queue));
    printf("Dequeued element: %d\n", dequeue(&queue));
    printf("Dequeued element: %d\n", dequeue(&queue));

    printQueue(&queue);

    return 0;
}