//GEMINI-pro DATASET v1.0 Category: System boot optimizer ; Style: multi-threaded
#include <stdio.h>
#include <stdlib.h>
#include <pthread.h>
#include <unistd.h>
#include <sys/time.h>

#define NUM_THREADS 4

// Data structure to store the boot time
struct boot_time {
    struct timeval tv;
    char *name;
};

// Thread function to measure the boot time
void *measure_boot_time(void *arg) {
    struct boot_time *bt = (struct boot_time *)arg;

    // Get the current time
    gettimeofday(&bt->tv, NULL);

    // Print the boot time
    printf("%s: %ld.%06ld\n", bt->name, bt->tv.tv_sec, bt->tv.tv_usec);

    return NULL;
}

int main() {
    // Create an array of boot time structures
    struct boot_time bt_array[NUM_THREADS];

    // Create an array of thread IDs
    pthread_t tid[NUM_THREADS];

    // Create the threads
    for (int i = 0; i < NUM_THREADS; i++) {
        bt_array[i].name = malloc(16);
        sprintf(bt_array[i].name, "Thread %d", i);
        pthread_create(&tid[i], NULL, measure_boot_time, &bt_array[i]);
    }

    // Join the threads
    for (int i = 0; i < NUM_THREADS; i++) {
        pthread_join(tid[i], NULL);
    }

    // Free the allocated memory
    for (int i = 0; i < NUM_THREADS; i++) {
        free(bt_array[i].name);
    }

    return 0;
}