//Gemma-7B DATASET v1.0 Category: Port Scanner ; Style: thoughtful
#include <stdio.h>
#include <netdb.h>
#include <sys/socket.h>
#include <unistd.h>
#include <stdlib.h>
#include <string.h>
#include <arpa/inet.h>

#define BUFFER_SIZE 1024

int main()
{
    int sockfd, newsockfd, portno, n, client_len;
    struct sockaddr_in serv_addr, client_addr;

    // Create a socket
    sockfd = socket(AF_INET, SOCK_STREAM, htons(6));
    if (sockfd < 0)
    {
        perror("Error creating socket");
        exit(1);
    }

    // Bind the socket to a port
    serv_addr.sin_port = htons(8080);
    serv_addr.sin_family = AF_INET;
    if (bind(sockfd, (struct sockaddr *)&serv_addr, sizeof(serv_addr)) < 0)
    {
        perror("Error binding socket");
        exit(1);
    }

    // Listen for connections
    listen(sockfd, 5);

    // Accept a connection
    newsockfd = accept(sockfd, (struct sockaddr *)&client_addr, &client_len);
    if (newsockfd < 0)
    {
        perror("Error accepting connection");
        exit(1);
    }

    // Send a message to the client
    char msg[] = "Hello, world!";
    n = write(newsockfd, msg, sizeof(msg));
    if (n < 0)
    {
        perror("Error sending message");
        exit(1);
    }

    // Close the connection
    close(newsockfd);

    return 0;
}