//Falcon-180B DATASET v1.0 Category: Password Strength Checker ; Style: minimalist
#include <stdio.h>
#include <string.h>
#include <ctype.h>
#include <stdbool.h>

#define MIN_LENGTH 8
#define MAX_LENGTH 32

bool isValidPassword(const char* password) {
    int length = strlen(password);
    if (length < MIN_LENGTH || length > MAX_LENGTH) {
        return false;
    }

    bool hasUpper = false;
    bool hasLower = false;
    bool hasNumber = false;
    bool hasSpecial = false;

    for (int i = 0; i < length; i++) {
        char c = tolower(password[i]);
        if (isalpha(c)) {
            if (isupper(c)) {
                hasUpper = true;
            } else {
                hasLower = true;
            }
        } else if (isdigit(c)) {
            hasNumber = true;
        } else if (c == '!' || c == '@' || c == '#' || c == '$' || c == '%' || c == '^' || c == '&' || c == '*' || c == '(' || c == ')' || c == '-' || c == '+' || c == '=' || c == '{' || c == '}' || c == '[' || c == ']' || c == '|' || c == ';' || c == ':' || c == ',' || c == '.' || c == '<' || c == '>' || c == '? ') {
            hasSpecial = true;
        }
    }

    return hasUpper && hasLower && hasNumber && hasSpecial;
}

int main() {
    char password[MAX_LENGTH];
    printf("Enter a password: ");
    fgets(password, MAX_LENGTH, stdin);

    if (isValidPassword(password)) {
        printf("Password is strong.\n");
    } else {
        printf("Password is weak.\n");
    }

    return 0;
}