//MISTRAL-7B DATASET v1.0 Category: Pixel Art Generator ; Style: creative
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define WIDTH 21
#define HEIGHT 11

typedef struct {
    int x;
    int y;
} point;

void print_heart(int x, int y) {
    printf("\033[%d;%dH", y, x);
    printf("  _____\n");
    printf(" /      \\/\n");
    printf("(      )  \n");
    printf("|      | \n");
    printf("|      | \n");
    printf("|      | \n");
    printf("|______| \n");
}

void generate_heart(char image[HEIGHT][WIDTH]) {
    point points[] = {
        {10, 2}, {11, 3}, {12, 4}, {13, 5}, {14, 6}, {15, 7}, {16, 8},
        {17, 9}, {18, 10}
    };

    for (int i = 0; i < sizeof(points) / sizeof(points[0]); i++) {
        print_heart(points[i].x, points[i].y);
        image[points[i].y][points[i].x] = 'X';
    }
}

int main() {
    char image[HEIGHT][WIDTH];
    memset(image, ' ', sizeof(image));

    generate_heart(image);

    for (int i = 0; i < HEIGHT; i++) {
        for (int j = 0; j < WIDTH; j++) {
            printf("%c", image[i][j]);
        }
        printf("\n");
    }

    return 0;
}