//Falcon-180B DATASET v1.0 Category: Cafe Billing System ; Style: irregular
#include <stdio.h>
#include <stdlib.h>

#define MAX_ITEMS 100
#define MAX_NAME_LEN 50
#define MAX_PRICE 1000

typedef struct{
    char name[MAX_NAME_LEN];
    float price;
} Item;

Item menu[MAX_ITEMS];

int num_items = 0;

void add_item(char* name, float price){
    if(num_items >= MAX_ITEMS){
        printf("Menu is full.\n");
        return;
    }
    strcpy(menu[num_items].name, name);
    menu[num_items].price = price;
    num_items++;
}

void print_menu(){
    printf("MENU:\n");
    for(int i=0; i<num_items; i++){
        printf("%d. %s - $%.2f\n", i+1, menu[i].name, menu[i].price);
    }
}

void place_order(int customer_id, int item_id, int quantity){
    printf("Customer %d ordered %d units of %s.\n", customer_id, quantity, menu[item_id-1].name);
}

void generate_bill(int customer_id){
    float total = 0;
    printf("Generating bill for customer %d:\n", customer_id);
    for(int i=0; i<num_items; i++){
        if(menu[i].price > 0){
            total += menu[i].price;
            printf("%s - $%.2f\n", menu[i].name, menu[i].price);
        }
    }
    printf("Total: $%.2f\n", total);
}

int main(){
    add_item("Coffee", 3.50);
    add_item("Tea", 2.50);
    add_item("Cake", 4.99);
    add_item("Sandwich", 6.99);

    print_menu();

    place_order(1, 1, 2);
    place_order(2, 2, 1);
    place_order(3, 3, 1);

    generate_bill(1);
    generate_bill(2);
    generate_bill(3);

    return 0;
}