//Falcon-180B DATASET v1.0 Category: Digital Auction System ; Style: cheerful
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define MAX_ITEMS 100
#define MAX_USERS 50
#define MAX_BIDS 100

typedef struct {
    char name[50];
    int id;
    int balance;
} User;

typedef struct {
    char name[100];
    int id;
    int price;
    int highest_bid;
    int highest_bidder_id;
} Item;

User users[MAX_USERS];
Item items[MAX_ITEMS];

int num_users = 0;
int num_items = 0;

void createUser(char* name) {
    strcpy(users[num_users].name, name);
    users[num_users].id = num_users + 1;
    users[num_users].balance = 1000;
    num_users++;
}

void createItem(char* name, int price) {
    strcpy(items[num_items].name, name);
    items[num_items].id = num_items + 1;
    items[num_items].price = price;
    items[num_items].highest_bid = 0;
    items[num_items].highest_bidder_id = 0;
    num_items++;
}

void displayItems() {
    printf("ITEMS:\n");
    for (int i = 0; i < num_items; i++) {
        printf("%d. %s - $%d (Highest bid: $%d by user %d)\n", items[i].id, items[i].name, items[i].price, items[i].highest_bid, items[i].highest_bidder_id);
    }
}

void placeBid(int item_id, int bid_amount, int user_id) {
    if (items[item_id - 1].highest_bid < bid_amount) {
        items[item_id - 1].highest_bid = bid_amount;
        items[item_id - 1].highest_bidder_id = user_id;
    }
}

int main() {
    createUser("Alice");
    createUser("Bob");
    createUser("Charlie");

    createItem("Laptop", 500);
    createItem("Phone", 300);
    createItem("Tablet", 200);

    displayItems();

    placeBid(1, 550, 1);
    placeBid(2, 325, 2);
    placeBid(3, 225, 3);

    displayItems();

    return 0;
}