//Falcon-180B DATASET v1.0 Category: Email Client ; Style: interoperable
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <sys/socket.h>
#include <arpa/inet.h>
#include <unistd.h>
#include <fcntl.h>
#include <errno.h>
#include <time.h>
#include <sys/time.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/mman.h>

#define PORT 110
#define MAX_LINE 1024
#define EMAIL_LEN 50


int main(int argc, char *argv[]) {
    int sockfd;
    struct sockaddr_in servaddr;
    char hostname[20] = "localhost";
    char username[EMAIL_LEN] = "username";
    char password[EMAIL_LEN] = "password";
    char command[MAX_LINE];
    char response[MAX_LINE];
    int n;

    sockfd = socket(AF_INET, SOCK_STREAM, 0);
    if (sockfd < 0) {
        printf("Error: Socket creation failed\n");
        exit(1);
    }

    memset(&servaddr, 0, sizeof(servaddr));
    servaddr.sin_family = AF_INET;
    servaddr.sin_port = htons(PORT);
    inet_pton(AF_INET, hostname, &servaddr.sin_addr);

    if (connect(sockfd, (struct sockaddr *)&servaddr, sizeof(servaddr)) < 0) {
        printf("Error: Connection failed\n");
        exit(1);
    }

    printf("Connected to server\n");

    strcpy(command, "login ");
    strcat(command, username);
    strcat(command, " ");
    strcat(command, password);
    send(sockfd, command, strlen(command), 0);

    n = recv(sockfd, response, MAX_LINE, 0);
    if (n < 0) {
        printf("Error: Login failed\n");
        exit(1);
    }

    printf("Login successful\n");

    strcpy(command, "list ");
    send(sockfd, command, strlen(command), 0);

    n = recv(sockfd, response, MAX_LINE, 0);
    if (n < 0) {
        printf("Error: List failed\n");
        exit(1);
    }

    printf("Email list:\n%s", response);

    strcpy(command, "retrieve ");
    strcat(command, "1 ");
    send(sockfd, command, strlen(command), 0);

    n = recv(sockfd, response, MAX_LINE, 0);
    if (n < 0) {
        printf("Error: Retrieve failed\n");
        exit(1);
    }

    printf("Email retrieved:\n%s", response);

    strcpy(command, "delete ");
    strcat(command, "1 ");
    send(sockfd, command, strlen(command), 0);

    n = recv(sockfd, response, MAX_LINE, 0);
    if (n < 0) {
        printf("Error: Delete failed\n");
        exit(1);
    }

    printf("Email deleted:\n%s", response);

    close(sockfd);
    return 0;
}