//Gemma-7B DATASET v1.0 Category: URL Sanitizer ; Style: invasive
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define MAX_URL_LENGTH 1024

void sanitize_url(char *url)
{
    char *p = url;
    char *q = url;

    // Strip leading and trailing whitespace
    while (*p == ' ' || *p == '\t' || *p == '\n')
    {
        *p++ = '\0';
    }

    // Remove invalid characters
    while (*q)
    {
        if (!((*q >= 'a' && *q <= 'z') || (*q >= 'A' && *q <= 'Z') || (*q >= '0' && *q <= '9') || *q == '.' || *q == '-') || *q == '_')
        {
            *q = '\0';
        }
        else
        {
            q++;
        }
    }

    // Normalize case
    char *r = url;
    while (*r)
    {
        *r = tolower(*r);
        r++;
    }

    // Return sanitized URL
    return;
}

int main()
{
    char url[MAX_URL_LENGTH] = "This is a sample URL with invalid characters and whitespace.";

    sanitize_url(url);

    printf("Sanitized URL: %s\n", url);

    return 0;
}