//Falcon-180B DATASET v1.0 Category: Maze Route Finder ; Style: brave
#include <stdio.h>
#include <stdlib.h>
#include <time.h>

#define WIDTH 20
#define HEIGHT 10

// Function to generate random maze
void generate_maze(char maze[HEIGHT][WIDTH]) {
    int x, y;
    for (y = 0; y < HEIGHT; y++) {
        for (x = 0; x < WIDTH; x++) {
            maze[y][x] = rand() % 2? '.' : '#';
        }
    }

    // Set start and end points
    maze[0][0] = '.';
    maze[HEIGHT - 1][WIDTH - 1] = 'E';
}

// Function to print the maze
void print_maze(const char maze[HEIGHT][WIDTH]) {
    int x, y;
    for (y = 0; y < HEIGHT; y++) {
        for (x = 0; x < WIDTH; x++) {
            printf("%c", maze[y][x]);
        }
        printf("\n");
    }
}

// Function to find the path using depth-first search algorithm
void dfs(char maze[HEIGHT][WIDTH], int x, int y, int dx, int dy) {
    maze[y][x] = 'V';
    if (x == WIDTH - 1 && y == HEIGHT - 1) {
        printf("Found path:\n");
        print_maze(maze);
        exit(0);
    }

    if (x < 0 || x >= WIDTH || y < 0 || y >= HEIGHT || maze[y][x] == '#') {
        return;
    }

    dfs(maze, x + dx, y + dy, dx, dy);
}

int main() {
    srand(time(NULL));
    char maze[HEIGHT][WIDTH];
    generate_maze(maze);
    print_maze(maze);

    int x = 0, y = 0;
    while (maze[y][x]!= '.') {
        x++;
    }
    x--;
    y++;

    dfs(maze, x, y, 0, 1);

    return 0;
}