//MISTRAL-7B DATASET v1.0 Category: Database Indexing System ; Style: minimalist
#include <stdio.h>
#include <stdlib.h>
#include <sqlite3.h>

static int callback(void *data, int argc, char **argv, char **azColName) {
    int i;
    for (i = 0; i < argc; i++) {
        printf("%s = %s\n", azColName[i], argv[i] ? argv[i] : "NULL");
    }
    printf("\n");
    return 0;
}

int main(void) {
    sqlite3 *db;
    int rc;

    rc = sqlite3_open("students.db", &db);
    if (rc) {
        fprintf(stderr, "Can't open database: %s\n", sqlite3_errmsg(db));
        sqlite3_close(db);
        return 1;
    }

    const char *create_table_sql = "CREATE TABLE IF NOT EXISTS students (\
                                    roll_no INTEGER PRIMARY KEY,\
                                    name TEXT NOT NULL,\
                                    age INTEGER NOT NULL,\
                                    marks INTEGER\
                                );";

    rc = sqlite3_exec(db, create_table_sql, callback, 0, 0);
    if (rc != SQLITE_OK) {
        fprintf(stderr, "SQL error: %s\n", sqlite3_errmsg(db));
        sqlite3_close(db);
        return 1;
    }

    const char *index_sql = "CREATE INDEX IF NOT EXISTS marks_index ON students (marks);";

    rc = sqlite3_exec(db, index_sql, callback, 0, 0);
    if (rc != SQLITE_OK) {
        fprintf(stderr, "SQL error: %s\n", sqlite3_errmsg(db));
        sqlite3_close(db);
        return 1;
    }

    printf("Table created successfully\n");

    sqlite3_close(db);
    return 0;
}