//Falcon2-11B DATASET v1.0 Category: Interprocess communication ; Style: standalone
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <unistd.h>
#include <errno.h>
#include <signal.h>

int main() {
    pid_t child_pid, status;
    int pipefd[2];
    char buffer[1024];

    if (pipe(pipefd) == -1) {
        perror("pipe");
        return 1;
    }

    child_pid = fork();

    if (child_pid < 0) {
        perror("fork");
        return 1;
    } else if (child_pid > 0) {
        close(pipefd[0]);

        if (dup2(pipefd[1], STDIN_FILENO) == -1) {
            perror("dup2");
            return 1;
        }

        if (dup2(pipefd[1], STDOUT_FILENO) == -1) {
            perror("dup2");
            return 1;
        }

        if (close(pipefd[1]) == -1) {
            perror("close");
            return 1;
        }

        execlp("./server", "./server", NULL);
    }

    close(pipefd[1]);

    if (write(pipefd[0], "Hello World!\n", 12) == -1) {
        perror("write");
        return 1;
    }

    if (read(pipefd[1], buffer, 1024) == -1) {
        perror("read");
        return 1;
    }

    printf("Child Process: %s\n", buffer);

    if (wait(&status) == -1) {
        perror("wait");
        return 1;
    }

    return 0;
}