//GEMINI-pro DATASET v1.0 Category: Log analysis ; Style: active
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>

// Define the log levels
#define LOG_LEVEL_ERROR   0
#define LOG_LEVEL_WARNING 1
#define LOG_LEVEL_INFO    2
#define LOG_LEVEL_DEBUG   3

// Define the log file name
#define LOG_FILE_NAME "log.txt"

// Define the maximum log file size (in bytes)
#define LOG_FILE_MAX_SIZE 1024 * 1024

// Define the log buffer size (in bytes)
#define LOG_BUFFER_SIZE 1024

// Define the log buffer
char log_buffer[LOG_BUFFER_SIZE];

// Define the log file pointer
FILE *log_file;

// Open the log file
void log_open()
{
    log_file = fopen(LOG_FILE_NAME, "a");
    if (log_file == NULL)
    {
        perror("fopen");
        exit(1);
    }
}

// Close the log file
void log_close()
{
    fclose(log_file);
}

// Write a log message to the log file
void log_write(int level, const char *message)
{
    // Get the current time
    time_t now = time(NULL);
    struct tm *tm = localtime(&now);

    // Format the log message
    snprintf(log_buffer, LOG_BUFFER_SIZE, "%s %d %s: %s\n", asctime(tm), level, __func__, message);

    // Write the log message to the log file
    fwrite(log_buffer, 1, strlen(log_buffer), log_file);

    // Flush the log file
    fflush(log_file);
}

// Check the log file size and truncate it if necessary
void log_check_size()
{
    // Get the log file size
    long log_file_size = ftell(log_file);

    // If the log file size is greater than the maximum log file size, truncate it
    if (log_file_size > LOG_FILE_MAX_SIZE)
    {
        freopen(LOG_FILE_NAME, "w", log_file);
    }
}

// Main function
int main()
{
    // Open the log file
    log_open();

    // Write a log message to the log file
    log_write(LOG_LEVEL_INFO, "This is an informational message.");

    // Write a log message to the log file
    log_write(LOG_LEVEL_WARNING, "This is a warning message.");

    // Write a log message to the log file
    log_write(LOG_LEVEL_ERROR, "This is an error message.");

    // Write a log message to the log file
    log_write(LOG_LEVEL_DEBUG, "This is a debug message.");

    // Close the log file
    log_close();

    return 0;
}