//Falcon-180B DATASET v1.0 Category: CPU usage monitor ; Style: invasive
#include <stdio.h>
#include <stdlib.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <unistd.h>
#include <string.h>
#include <sys/time.h>
#include <time.h>

#define BUFFER_SIZE 1024

// Function to get CPU usage
float get_cpu_usage() {
    FILE *file;
    char buffer[BUFFER_SIZE];
    float cpu_percent = 0.0;
    int total_cpu = 0;
    int idle_cpu = 0;

    // Open the file
    file = fopen("/proc/stat", "r");

    // Check if the file was opened successfully
    if (file == NULL) {
        printf("Error opening /proc/stat\n");
        exit(1);
    }

    // Read the first line
    fgets(buffer, BUFFER_SIZE, file);

    // Close the file
    fclose(file);

    // Parse the first line
    char *token = strtok(buffer, " ");
    while (token!= NULL) {
        if (strcmp(token, "cpu") == 0) {
            token = strtok(NULL, " ");
            total_cpu = atoi(token);
        } else if (strcmp(token, "idle") == 0) {
            token = strtok(NULL, " ");
            idle_cpu = atoi(token);
        }
        token = strtok(NULL, " ");
    }

    // Calculate the CPU usage
    cpu_percent = ((total_cpu - idle_cpu) * 100.0) / total_cpu;

    return cpu_percent;
}

// Function to print CPU usage
void print_cpu_usage(float cpu_percent) {
    printf("CPU usage: %.2f%%\n", cpu_percent);
}

// Main function
int main() {
    float cpu_usage;

    // Loop indefinitely
    while (1) {
        // Get the current CPU usage
        cpu_usage = get_cpu_usage();

        // Print the CPU usage
        print_cpu_usage(cpu_usage);

        // Wait for 1 second
        sleep(1);
    }

    return 0;
}