//GEMINI-pro DATASET v1.0 Category: Electronic Voting System ; Style: synchronous
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define MAX_CANDIDATES 10
#define MAX_VOTERS 100

typedef struct {
    char name[50];
    int votes;
} candidate;

typedef struct {
    char name[50];
    int candidate_id;
} voter;

candidate candidates[MAX_CANDIDATES];
voter voters[MAX_VOTERS];

int num_candidates = 0;
int num_voters = 0;

void add_candidate(char *name) {
    strcpy(candidates[num_candidates].name, name);
    candidates[num_candidates].votes = 0;
    num_candidates++;
}

void add_voter(char *name, int candidate_id) {
    strcpy(voters[num_voters].name, name);
    voters[num_voters].candidate_id = candidate_id;
    num_voters++;
}

void vote(int voter_id, int candidate_id) {
    candidates[candidate_id].votes++;
}

void print_results() {
    int i;

    for (i = 0; i < num_candidates; i++) {
        printf("%s: %d votes\n", candidates[i].name, candidates[i].votes);
    }
}

int main() {
    int i;

    add_candidate("John Smith");
    add_candidate("Jane Doe");
    add_candidate("Bob Jones");

    add_voter("Alice", 0);
    add_voter("Bob", 1);
    add_voter("Carol", 2);

    vote(0, 0);
    vote(1, 1);
    vote(2, 2);

    print_results();

    return 0;
}