//MISTRAL-7B DATASET v1.0 Category: Modern Encryption ; Style: happy
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <time.h>

// Function to encrypt a character using Caesar Cipher with given key
char encrypt_char(char c, int key) {
    return (char)(((int)c + key) % 26);
}

// Function to decrypt a character using Caesar Cipher with given key
char decrypt_char(char c, int key) {
    return encrypt_char(c, -key);
}

// Function to encrypt a string using Caesar Cipher with given key
void encrypt_string(char* str, int key) {
    int len = strlen(str);
    for (int i = 0; i < len; i++) {
        str[i] = encrypt_char(str[i], key);
    }
}

// Function to decrypt a string using Caesar Cipher with given key
void decrypt_string(char* str, int key) {
    int len = strlen(str);
    for (int i = 0; i < len; i++) {
        str[i] = decrypt_char(str[i], key);
    }
}

// Function to generate a random key for encryption/decryption
int generate_key() {
    srand(time(NULL));
    return rand() % 26;
}

int main() {
    char original_str[100];
    char encrypted_str[100];
    char decrypted_str[100];

    printf("Enter a string to encrypt: ");
    fgets(original_str, sizeof(original_str), stdin);
    original_str[strcspn(original_str, "\n")] = '\0';

    int key = generate_key();
    printf("Generated key: %d\n", key);

    encrypt_string(encrypted_str, key);
    strcat(encrypted_str, original_str);

    printf("Encrypted string: %s\n", encrypted_str);

    decrypt_string(decrypted_str, key);

    printf("Decrypted string: %s\n", decrypted_str);

    return 0;
}