//GPT-4o-mini DATASET v1.0 Category: Weather simulation ; Style: retro
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <time.h>

#define MAX_DAYS 7
#define MAX_TEMP 40
#define MIN_TEMP -10
#define WEATHER_TYPES 5

typedef enum {
    SUNNY,
    RAINY,
    CLOUDY,
    WINDY,
    SNOWY
} WeatherType;

const char *weather_descriptions[] = {
    "🌞 Sunny",
    "🌧️ Rainy",
    "☁️ Cloudy",
    "💨 Windy",
    "❄️ Snowy"
};

typedef struct {
    WeatherType type;
    int temperature;
} Weather;

void generate_weather(Weather *day) {
    day->type = rand() % WEATHER_TYPES;
    day->temperature = (rand() % (MAX_TEMP - MIN_TEMP + 1)) + MIN_TEMP;
}

void print_weather(Weather *day, int day_number) {
    printf("Day %d: %s with a temperature of %d°C.\n",
           day_number + 1,
           weather_descriptions[day->type],
           day->temperature);
}

void simulate_weather() {
    Weather week_weather[MAX_DAYS];

    srand(time(0)); // Seed random number generator

    printf("Welcome to the Retro Weather Simulation!\n");
    printf("-----------------------------------------\n");

    for (int i = 0; i < MAX_DAYS; i++) {
        generate_weather(&week_weather[i]);
        print_weather(&week_weather[i], i);
        sleep(1); // Pause for effect (1 second)
    }

    printf("\nThis concludes the weather simulation for the week!\n");
    printf("Enjoy your day, come back for tomorrow's forecast!\n");
}

int main() {
    simulate_weather();
    return 0;
}