//Falcon-180B DATASET v1.0 Category: Percolation Simulator ; Style: post-apocalyptic
#include <stdio.h>
#include <stdlib.h>
#include <time.h>

#define ROWS 20
#define COLS 30
#define DROPS 100

typedef struct {
    int row;
    int col;
} cell;

void createBoard(cell board[ROWS][COLS]) {
    int i, j;
    for (i = 0; i < ROWS; i++) {
        for (j = 0; j < COLS; j++) {
            board[i][j].row = i;
            board[i][j].col = j;
        }
    }
}

void addDrop(cell board[ROWS][COLS], int numDrops) {
    int row, col;
    srand(time(NULL));
    for (int i = 0; i < numDrops; i++) {
        row = rand() % ROWS;
        col = rand() % COLS;
        while (board[row][col].row!= -1) {
            row = rand() % ROWS;
            col = rand() % COLS;
        }
        board[row][col].row = -1;
    }
}

void printBoard(cell board[ROWS][COLS]) {
    int i, j;
    for (i = 0; i < ROWS; i++) {
        for (j = 0; j < COLS; j++) {
            if (board[i][j].row == -1) {
                printf("*");
            } else {
                printf(".");
            }
        }
        printf("\n");
    }
}

void percolate(cell board[ROWS][COLS], int row, int col) {
    if (row < 0 || row >= ROWS || col < 0 || col >= COLS)
        return;
    if (board[row][col].row!= -1)
        return;
    board[row][col].row = -1;
    percolate(board, row - 1, col);
    percolate(board, row + 1, col);
    percolate(board, row, col - 1);
    percolate(board, row, col + 1);
}

int main() {
    cell board[ROWS][COLS];
    createBoard(board);
    addDrop(board, DROPS);
    printBoard(board);
    percolate(board, 0, 0);
    printBoard(board);
    return 0;
}