//GEMINI-pro DATASET v1.0 Category: Client Server Application ; Style: romantic
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>

#define PORT 8080

int main() {
  // Create a socket.
  int sockfd = socket(AF_INET, SOCK_STREAM, 0);
  if (sockfd < 0) {
    perror("socket");
    return EXIT_FAILURE;
  }

  // Bind the socket to the address and port.
  struct sockaddr_in servaddr;
  memset(&servaddr, 0, sizeof(servaddr));
  servaddr.sin_family = AF_INET;
  servaddr.sin_addr.s_addr = inet_addr("127.0.0.1");
  servaddr.sin_port = htons(PORT);
  if (bind(sockfd, (const struct sockaddr *)&servaddr, sizeof(servaddr)) < 0) {
    perror("bind");
    return EXIT_FAILURE;
  }

  // Listen for connections.
  if (listen(sockfd, 5) < 0) {
    perror("listen");
    return EXIT_FAILURE;
  }

  // Accept a connection.
  int connfd = accept(sockfd, NULL, NULL);
  if (connfd < 0) {
    perror("accept");
    return EXIT_FAILURE;
  }

  // Send a message to the client.
  char *message = "Hello, my love!";
  if (send(connfd, message, strlen(message), 0) < 0) {
    perror("send");
    return EXIT_FAILURE;
  }

  // Receive a message from the client.
  char buffer[1024];
  if (recv(connfd, buffer, sizeof(buffer), 0) < 0) {
    perror("recv");
    return EXIT_FAILURE;
  }

  // Print the message from the client.
  printf("My love says: %s\n", buffer);

  // Close the connection.
  close(connfd);
  close(sockfd);

  return EXIT_SUCCESS;
}