//Gemma-7B DATASET v1.0 Category: CPU Scheduling Algorithms ; Style: secure
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>

#define MAX_PROCESSES 10

typedef struct Process {
    int pid;
    char name[20];
    int burst_time;
    int waiting_time;
    int turnaround_time;
} Process;

void calculate_turnaround_time(Process *process) {
    process->turnaround_time = process->waiting_time + process->burst_time;
}

void simulate_process(Process *process) {
    printf("Process %s is running...\n", process->name);
    sleep(process->burst_time);
    printf("Process %s has completed.\n", process->name);
}

int main() {
    Process processes[MAX_PROCESSES];
    int i, quantum = 2;

    // Create processes
    for (i = 0; i < MAX_PROCESSES; i++) {
        processes[i].pid = i + 1;
        processes[i].name[0] = 'A' + i;
        processes[i].burst_time = rand() % 5 + 1;
        processes[i].waiting_time = 0;
        processes[i].turnaround_time = 0;
    }

    // Calculate turnaround time for each process
    for (i = 0; i < MAX_PROCESSES; i++) {
        calculate_turnaround_time(&processes[i]);
    }

    // Simulate process execution
    for (i = 0; i < MAX_PROCESSES; i++) {
        simulate_process(&processes[i]);
    }

    // Print process completion times
    for (i = 0; i < MAX_PROCESSES; i++) {
        printf("Process %s turnaround time: %d\n", processes[i].name, processes[i].turnaround_time);
    }

    return 0;
}