//Falcon-180B DATASET v1.0 Category: File system simulation ; Style: standalone
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>

#define MAX_FILES 100
#define MAX_FILE_NAME_LENGTH 20
#define MAX_FILE_SIZE 1024

typedef struct {
    char name[MAX_FILE_NAME_LENGTH];
    char data[MAX_FILE_SIZE];
} File;

int numFiles = 0;
File files[MAX_FILES];

void createFile(char* name) {
    if (numFiles >= MAX_FILES) {
        printf("Error: Too many files\n");
        return;
    }
    strcpy(files[numFiles].name, name);
    numFiles++;
}

void deleteFile(char* name) {
    int i;
    for (i = 0; i < numFiles; i++) {
        if (strcmp(files[i].name, name) == 0) {
            memset(files[i].data, 0, MAX_FILE_SIZE);
            numFiles--;
            break;
        }
    }
}

void writeFile(char* name, char* data) {
    int i;
    for (i = 0; i < numFiles; i++) {
        if (strcmp(files[i].name, name) == 0) {
            strcpy(files[i].data, data);
            break;
        }
    }
}

void readFile(char* name) {
    int i;
    for (i = 0; i < numFiles; i++) {
        if (strcmp(files[i].name, name) == 0) {
            printf("File contents:\n%s\n", files[i].data);
            break;
        }
    }
}

int main() {
    createFile("test.txt");
    writeFile("test.txt", "This is a test file. ");
    readFile("test.txt");
    deleteFile("test.txt");
    return 0;
}