//Falcon-180B DATASET v1.0 Category: Airport Baggage Handling Simulation ; Style: authentic
#include <stdio.h>
#include <stdlib.h>
#include <time.h>

#define NUM_BAGS 10
#define NUM_DESTINATIONS 5

enum {
    RED,
    BLUE,
    GREEN,
    YELLOW,
    ORANGE
};

struct Baggage {
    int id;
    int destination;
    int color;
};

struct Destination {
    int id;
    int num_bags;
};

void init_destinations(struct Destination *destinations) {
    for (int i = 0; i < NUM_DESTINATIONS; i++) {
        destinations[i].id = i + 1;
        destinations[i].num_bags = 0;
    }
}

void init_bags(struct Baggage *bags) {
    for (int i = 0; i < NUM_BAGS; i++) {
        bags[i].id = i + 1;
        bags[i].destination = rand() % NUM_DESTINATIONS + 1;
        bags[i].color = rand() % 5;
    }
}

void print_bag(struct Baggage bag) {
    printf("Bag %d: Destination %d, Color %d\n", bag.id, bag.destination, bag.color);
}

void print_dest(struct Destination dest) {
    printf("Destination %d: %d bags\n", dest.id, dest.num_bags);
}

int main() {
    srand(time(NULL));

    struct Baggage bags[NUM_BAGS];
    struct Destination destinations[NUM_DESTINATIONS];

    init_destinations(destinations);
    init_bags(bags);

    for (int i = 0; i < NUM_BAGS; i++) {
        int dest_id = bags[i].destination;
        destinations[dest_id - 1].num_bags++;
    }

    for (int i = 0; i < NUM_DESTINATIONS; i++) {
        print_dest(destinations[i]);
    }

    for (int i = 0; i < NUM_BAGS; i++) {
        print_bag(bags[i]);
    }

    return 0;
}