//Code Llama-13B DATASET v1.0 Category: Database simulation ; Style: visionary
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>

#define MAX_RECORDS 100
#define MAX_NAME_LEN 25
#define MAX_ADDRESS_LEN 50

typedef struct {
    char name[MAX_NAME_LEN];
    char address[MAX_ADDRESS_LEN];
} Record;

void print_records(Record records[], int num_records) {
    for (int i = 0; i < num_records; i++) {
        printf("%s\t%s\n", records[i].name, records[i].address);
    }
}

void add_record(Record records[], int* num_records, char* name, char* address) {
    if (*num_records < MAX_RECORDS) {
        strcpy(records[*num_records].name, name);
        strcpy(records[*num_records].address, address);
        (*num_records)++;
    }
}

void remove_record(Record records[], int* num_records, char* name) {
    for (int i = 0; i < *num_records; i++) {
        if (strcmp(records[i].name, name) == 0) {
            for (int j = i; j < *num_records - 1; j++) {
                records[j] = records[j + 1];
            }
            (*num_records)--;
            break;
        }
    }
}

int main() {
    Record records[MAX_RECORDS];
    int num_records = 0;

    add_record(records, &num_records, "John", "123 Main St");
    add_record(records, &num_records, "Jane", "456 Elm St");
    add_record(records, &num_records, "Bob", "789 Oak St");

    print_records(records, num_records);

    remove_record(records, &num_records, "Bob");

    print_records(records, num_records);

    return 0;
}