//MISTRAL-7B DATASET v1.0 Category: Haunted House Simulator ; Style: light-weight
#include <stdio.h>
#include <stdlib.h>
#include <time.h>

#define NUM_GHOSTS 5
#define MIN_DELAY 500
#define MAX_DELAY 2000

void ghost_appear(void);

int main(void)
{
    srand(time(NULL));

    for (int i = 0; i < 10; i++)
    {
        ghost_appear();
        usleep(rand() % (MAX_DELAY - MIN_DELAY + 1) + MIN_DELAY);
    }

    return 0;
}

void ghost_appear(void)
{
    int x, y;

    printf("\033[H\033[J"); // Clear the terminal screen

    // Randomly select a position for the ghost to appear
    x = rand() % 20 + 1;
    y = rand() % 10 + 1;

    printf("\033[%d;%dH%s", y, x, "GHOST"); // Print the ghost at the random position

    // Generate a random sound effect for the ghost
    int sound = rand() % 4 + 1;
    switch (sound)
    {
    case 1:
        printf("\033[%d;%dH%s", y, x, "BOO!");
        break;
    case 2:
        printf("\033[%d;%dH%s", y, x, "RATTLE!");
        break;
    case 3:
        printf("\033[%d;%dH%s", y, x, "SPOOK!");
        break;
    case 4:
        printf("\033[%d;%dH%s", y, x, "SCREAM!");
        break;
    }
}