//Falcon-180B DATASET v1.0 Category: Client Server Application ; Style: multivariable
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <arpa/inet.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <unistd.h>
#include <errno.h>

#define MAX 100

int main() {
    int client_socket, new_socket, addrlen, valread, sd;
    struct sockaddr_in serv_addr, cli_addr;
    char buffer[MAX];

    char *message;
    message = "Server message";
    char *response;
    response = "Client message";

    // Create socket
    if ((sd = socket(AF_INET, SOCK_STREAM, 0)) == 0) {
        perror("socket failed");
        exit(EXIT_FAILURE);
    }

    puts("Socket created");

    // Set server address
    memset(&serv_addr, '0', sizeof(serv_addr));
    serv_addr.sin_family = AF_INET;
    serv_addr.sin_addr.s_addr = INADDR_ANY;
    serv_addr.sin_port = htons(12345);

    // Bind server address
    if (bind(sd, (struct sockaddr *)&serv_addr, sizeof(serv_addr)) < 0) {
        perror("bind failed");
        exit(EXIT_FAILURE);
    }

    puts("Server address bound");

    // Listen on socket
    if (listen(sd, 3) < 0) {
        perror("listen");
        exit(EXIT_FAILURE);
    }

    puts("Server listening");

    // Accept client connection
    addrlen = sizeof(cli_addr);
    if ((new_socket = accept(sd, (struct sockaddr *)&cli_addr, (socklen_t*)&addrlen)) < 0) {
        perror("accept");
        exit(EXIT_FAILURE);
    }

    puts("Client connected");

    // Send message to client
    send(new_socket, message, strlen(message), 0);

    // Receive response from client
    if ((valread = read(new_socket, buffer, sizeof(buffer))) <= 0) {
        if (valread == 0)
            printf("Client disconnected\n");
        else
            perror("read");
    } else {
        printf("Response from client: %s\n", buffer);
    }

    // Close sockets
    close(sd);
    close(new_socket);

    return 0;
}