//Code Llama-13B DATASET v1.0 Category: Expense Tracker ; Style: high level of detail
/*
 * Expense Tracker
 *
 * A program to keep track of expenses.
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define MAX_EXPENSES 100
#define MAX_DESCRIPTION_LENGTH 100

// Struct to represent an expense
typedef struct {
  char description[MAX_DESCRIPTION_LENGTH];
  float amount;
} Expense;

// Function to add an expense to the tracker
void add_expense(Expense* expenses, int* num_expenses, char* description, float amount) {
  // Check if there is space for another expense
  if (*num_expenses >= MAX_EXPENSES) {
    printf("Error: Cannot add more than %d expenses.\n", MAX_EXPENSES);
    return;
  }

  // Add the expense
  strcpy(expenses[*num_expenses].description, description);
  expenses[*num_expenses].amount = amount;
  (*num_expenses)++;
}

// Function to display the expenses
void display_expenses(Expense* expenses, int num_expenses) {
  // Check if there are any expenses
  if (num_expenses == 0) {
    printf("No expenses to display.\n");
    return;
  }

  // Display the expenses
  for (int i = 0; i < num_expenses; i++) {
    printf("%s: $%.2f\n", expenses[i].description, expenses[i].amount);
  }
}

int main() {
  // Create an array to store the expenses
  Expense expenses[MAX_EXPENSES];
  int num_expenses = 0;

  // Add some expenses
  add_expense(expenses, &num_expenses, "Rent", 1000);
  add_expense(expenses, &num_expenses, "Groceries", 200);
  add_expense(expenses, &num_expenses, "Coffee", 10);
  add_expense(expenses, &num_expenses, "Lunch", 15);

  // Display the expenses
  display_expenses(expenses, num_expenses);

  return 0;
}