//GEMINI-pro DATASET v1.0 Category: Bitwise operations ; Style: peaceful
/*
   A peaceful journey through bitwise operations in C.
   Let us embark on a harmonious exploration of the binary realm.

   "Bitwise operations are like a gentle caress,
   weaving the threads of data into intricate tapestries."
*/

#include <stdio.h>

// The binary dance begins with a gentle AND.
#define BITWISE_AND(a, b) (a & b)

// A harmonious OR weaves together the strands of possibility.
#define BITWISE_OR(a, b) (a | b)

// The XOR, a graceful dance of difference, reveals the unique.
#define BITWISE_XOR(a, b) (a ^ b)

// A soothing NOT inverts the flow, bringing forth the opposite.
#define BITWISE_NOT(a) (~a)

// Shifting bits, a rhythmic movement, expands or contracts our focus.
#define BITWISE_LEFT_SHIFT(a, n) (a << n)
#define BITWISE_RIGHT_SHIFT(a, n) (a >> n)

int main() {
    // Let us create a peaceful symphony of numbers:
    int num1 = 0b10101010; // A harmonious melody of ones and zeros
    int num2 = 0b01010101; // A complementary tune, echoing the first

    // The AND, a gentle embrace, weaves their rhythms:
    printf("AND: %d\n", BITWISE_AND(num1, num2));

    // The OR, a joyful union, merges their harmonies:
    printf("OR: %d\n", BITWISE_OR(num1, num2));

    // The XOR, a graceful dance, reveals their differences:
    printf("XOR: %d\n", BITWISE_XOR(num1, num2));

    // The NOT, a serene inversion, transforms the melody:
    printf("NOT of num1: %d\n", BITWISE_NOT(num1));

    // Shifting bits, a rhythmic expansion, unveils hidden patterns:
    printf("Left shift of num1 by 2: %d\n", BITWISE_LEFT_SHIFT(num1, 2));
    printf("Right shift of num1 by 2: %d\n", BITWISE_RIGHT_SHIFT(num1, 2));

    // In this peaceful realm of bitwise harmony, we find solace and understanding.
    // May this exploration inspire you to weave your own tapestry of computational grace.
    return 0;
}