//Gemma-7B DATASET v1.0 Category: Socket programming ; Style: multivariable
#include <sys/socket.h>
#include <netinet/in.h>
#include <stdio.h>
#include <string.h>

#define SERVER_PORT 8080

int main()
{
    int sockfd, newsockfd, portno, clilen, n;
    char buffer[1024];
    struct sockaddr_in serv_addr, cli_addr;

    // Create a socket
    sockfd = socket(AF_INET, SOCK_STREAM, htons(SERVER_PORT));
    if (sockfd < 0)
    {
        perror("Error creating socket");
        return 1;
    }

    // Bind the socket to a port
    serv_addr.sin_family = AF_INET;
    serv_addr.sin_port = htons(SERVER_PORT);
    if (bind(sockfd, (struct sockaddr *)&serv_addr, sizeof(serv_addr)) < 0)
    {
        perror("Error binding socket");
        return 1;
    }

    // Listen for connections
    listen(sockfd, &clilen);

    // Accept a connection
    newsockfd = accept(sockfd, (struct sockaddr *)&cli_addr, &clilen);
    if (newsockfd < 0)
    {
        perror("Error accepting connection");
        return 1;
    }

    // Send a message to the client
    n = write(newsockfd, "Hello, world!", 13);
    if (n < 0)
    {
        perror("Error sending message");
        return 1;
    }

    // Receive a message from the client
    n = read(newsockfd, buffer, 1024);
    if (n < 0)
    {
        perror("Error receiving message");
        return 1;
    }

    // Print the client's message
    printf("Client: %s\n", buffer);

    // Close the connection
    close(newsockfd);

    return 0;
}