//Gemma-7B DATASET v1.0 Category: Network Ping Test ; Style: optimized
#include <stdio.h>
#include <stdlib.h>
#include <netdb.h>
#include <sys/socket.h>
#include <unistd.h>
#include <time.h>

int main()
{
    int sockfd;
    struct sockaddr_in server_addr;
    char ping_message[10] = "PING";
    char reply_message[10] = "Reply";
    int bytes_sent, bytes_received;
    struct timeval tv;
    double start_time, end_time, total_time;

    // Create a socket
    sockfd = socket(AF_INET, SOCK_DGRAM, htons(8));
    if (sockfd < 0)
    {
        perror("Error creating socket");
        exit(1);
    }

    // Set up the server address
    server_addr.sin_family = AF_INET;
    server_addr.sin_port = htons(5000);
    server_addr.sin_addr.s_addr = inet_addr("192.168.1.1");

    // Send the ping message
    bytes_sent = sendto(sockfd, ping_message, sizeof(ping_message), 0, (struct sockaddr *)&server_addr, sizeof(server_addr));
    if (bytes_sent < 0)
    {
        perror("Error sending ping message");
        exit(1);
    }

    // Set up the time interval
    tv.tv_sec = 1;
    tv.tv_usec = 0;

    // Receive the reply message
    bytes_received = recvfrom(sockfd, reply_message, sizeof(reply_message), 0, (struct sockaddr *)&server_addr, NULL);
    if (bytes_received < 0)
    {
        perror("Error receiving reply message");
        exit(1);
    }

    // Calculate the start time
    start_time = time(NULL);

    // Calculate the end time
    end_time = time(NULL);

    // Calculate the total time
    total_time = end_time - start_time;

    // Print the results
    printf("Ping: %s\n", reply_message);
    printf("Time: %.2f seconds\n", total_time);

    // Close the socket
    close(sockfd);

    return 0;
}