//Falcon-180B DATASET v1.0 Category: RAM usage monitor ; Style: Sherlock Holmes
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define MAX_PROCESSES 100
#define MAX_PROCESS_NAME_LEN 50
#define MAX_PROCESS_COMMAND_LEN 100

typedef struct {
    char name[MAX_PROCESS_NAME_LEN];
    char command[MAX_PROCESS_COMMAND_LEN];
    int pid;
    int ramUsage;
} Process;

int numProcesses = 0;
Process processes[MAX_PROCESSES];

void addProcess(char* name, char* command, int pid) {
    if (numProcesses >= MAX_PROCESSES) {
        printf("Error: Maximum number of processes reached.\n");
        return;
    }

    Process* process = &processes[numProcesses];
    strcpy(process->name, name);
    strcpy(process->command, command);
    process->pid = pid;
    process->ramUsage = 0;

    numProcesses++;
}

void updateProcessRAMUsage(int pid, int ramUsage) {
    for (int i = 0; i < numProcesses; i++) {
        if (processes[i].pid == pid) {
            processes[i].ramUsage = ramUsage;
            break;
        }
    }
}

void printProcesses() {
    printf("Processes:\n");
    for (int i = 0; i < numProcesses; i++) {
        printf("Name: %s\nCommand: %s\nPID: %d\nRAM usage: %d bytes\n", processes[i].name, processes[i].command, processes[i].pid, processes[i].ramUsage);
    }
}

int main() {
    addProcess("Sherlock", "solveMystery", 1234);
    addProcess("Watson", "assistSherlock", 5678);

    updateProcessRAMUsage(1234, 1024); // Sherlock is using 1 KB of RAM
    updateProcessRAMUsage(5678, 2048); // Watson is using 2 KB of RAM

    printProcesses();

    return 0;
}