//Code Llama-13B DATASET v1.0 Category: Cafe Billing System ; Style: introspective
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define MAX_NAME_LEN 50
#define MAX_ITEM_NAME_LEN 20
#define MAX_ITEM_COUNT 50

// Structure to represent a customer
typedef struct {
    char name[MAX_NAME_LEN];
    int items[MAX_ITEM_COUNT];
    int item_count;
} Customer;

// Structure to represent an item
typedef struct {
    char name[MAX_ITEM_NAME_LEN];
    double price;
} Item;

// Function to print the bill for a customer
void print_bill(Customer *customer, Item *items, int item_count) {
    int i, j;
    double total = 0;

    printf("Bill for %s\n", customer->name);
    for (i = 0; i < customer->item_count; i++) {
        for (j = 0; j < item_count; j++) {
            if (customer->items[i] == items[j].name) {
                printf("  %s: %0.2f\n", items[j].name, items[j].price);
                total += items[j].price;
            }
        }
    }
    printf("Total: %0.2f\n", total);
}

int main() {
    Customer customers[] = {
        {"John", {1, 2, 3}, 3},
        {"Jane", {4, 5, 6}, 3},
        {"Bob", {7, 8, 9}, 3}
    };

    Item items[] = {
        {"Coffee", 2.5},
        {"Tea", 3.5},
        {"Espresso", 4.5},
        {"Latte", 5.5},
        {"Cappuccino", 6.5}
    };

    int i, j;
    for (i = 0; i < sizeof(customers) / sizeof(Customer); i++) {
        print_bill(&customers[i], items, sizeof(items) / sizeof(Item));
    }

    return 0;
}