//GPT-4o-mini DATASET v1.0 Category: Network Packet Monitoring ; Style: introspective
#include <stdio.h>
#include <stdlib.h>
#include <pcap.h>
#include <arpa/inet.h>
#include <netinet/ip.h>
#include <netinet/udp.h>
#include <string.h>

#define MAX_PACKET_SIZE 65536

void packet_handler(u_char *args, const struct pcap_pkthdr *header, const u_char *packet) {
    const struct ip *ip_header = (struct ip *)(packet + 14); // Skip Ethernet header
    const struct udphdr *udp_header = (struct udphdr *)(packet + 14 + (ip_header->ip_hl * 4));

    // Extracting source and destination information
    char src_ip[INET_ADDRSTRLEN];
    char dst_ip[INET_ADDRSTRLEN];
    inet_ntop(AF_INET, &(ip_header->ip_src), src_ip, INET_ADDRSTRLEN);
    inet_ntop(AF_INET, &(ip_header->ip_dst), dst_ip, INET_ADDRSTRLEN);

    printf("Packet captured:\n");
    printf("  - Timestamp: %s", ctime((const time_t *)&header->ts.tv_sec));
    printf("  - Source IP: %s\n", src_ip);
    printf("  - Destination IP: %s\n", dst_ip);
    printf("  - Source Port: %d\n", ntohs(udp_header->source));
    printf("  - Destination Port: %d\n", ntohs(udp_header->dest));
    printf("  - Packet Length: %d bytes\n\n", header->len);
}

void start_monitoring(const char *device) {
    char error_buffer[PCAP_ERRBUF_SIZE];
    pcap_t *handle = pcap_open_live(device, MAX_PACKET_SIZE, 1, 1000, error_buffer);

    if (handle == NULL) {
        fprintf(stderr, "Could not open device %s: %s\n", device, error_buffer);
        exit(EXIT_FAILURE);
    }

    printf("Listening on device %s...\n", device);
    pcap_loop(handle, 0, packet_handler, NULL);

    pcap_close(handle);
}

int main(int argc, char *argv[]) {
    if (argc != 2) {
        fprintf(stderr, "Usage: %s <network_device>\n", argv[0]);
        exit(EXIT_FAILURE);
    }

    char *device = argv[1];

    // Begin the introspective journey into packet monitoring
    printf("Initiating packet monitoring on the device: %s...\n", device);
    start_monitoring(device);

    return 0; // The end of our journey, but just a beginning for the knowledge of these packets
}